<?php
class AdminVehicleController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene todos los vehículos pendientes de verificación.
     * @return array Lista de vehículos con detalles del propietario.
     */
    public function getPendingVehicles() {
        $sql = "SELECT 
                    v.id, v.plate_number, v.brand, v.model, v.year, v.created_at,
                    u.document_number, u.first_name, u.last_name, u.company_name
                FROM vehicles v
                JOIN users u ON v.user_id = u.id
                WHERE v.status = 'pending_verification'
                ORDER BY v.created_at ASC";
        
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    // Aquí añadiremos más adelante las funciones para aprobar y rechazar.
}
?>