<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminActivityController.php';

$controller = new AdminActivityController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['activity_id'])) {
    header('Location: ../activity_verifications.php');
    exit;
}

$action = $_POST['action'];
$activityId = $_POST['activity_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approveActivity($activityId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Documentación incorrecta o incompleta.';
    if (empty(trim($reason))) {
        $reason = 'Documentación incorrecta o incompleta.';
    }
    $result = $controller->rejectActivity($activityId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../activity_verifications.php');
exit;
?>