<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminAdvertisementController.php';

$controller = new AdminAdvertisementController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['ad_id'])) {
    header('Location: ../advertisement_verifications.php');
    exit;
}

$action = $_POST['action'];
$adId = $_POST['ad_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approveAdvertisement($adId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Documentación incorrecta o incompleta.';
    if (empty(trim($reason))) $reason = 'Documentación incorrecta o incompleta.';
    $result = $controller->rejectAdvertisement($adId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../advertisement_verifications.php');
exit;
?>