<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminFiscalizationController.php';
require_once '../controllers/TaxController.php'; // Incluimos TaxController para crear multas

$controller = new AdminFiscalizationController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'create_audit') {
        // Necesitaremos una configuración para el "concepto de impuesto" de tipo multa
        if (!getSystemConfig('fine_tax_concept_id')) {
            setAlert('Error: No se ha configurado un "Concepto Tributario" para multas en los ajustes del sistema.', 'error');
            header('Location: ../fiscalization_form.php');
            exit;
        }

        $result = $controller->createAudit($_POST);
        setAlert($result['message'], $result['success'] ? 'success' : 'error');
        header('Location: ../fiscalization.php');
        exit;
    }
}

header('Location: ../fiscalization.php');
exit;