<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminLicenseController.php';

$controller = new AdminLicenseController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['license_id'])) {
    header('Location: ../license_verifications.php');
    exit;
}

$action = $_POST['action'];
$licenseId = $_POST['license_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approveLicense($licenseId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Información incompleta o incorrecta.';
    if (empty(trim($reason))) {
        $reason = 'Información incompleta o incorrecta.';
    }
    $result = $controller->rejectLicense($licenseId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../license_verifications.php');
exit;
?>