<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminPermitController.php';

$controller = new AdminPermitController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['permit_id'])) {
    header('Location: ../permit_verifications.php');
    exit;
}

$action = $_POST['action'];
$permitId = $_POST['permit_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approvePermit($permitId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Documentación o información insuficiente.';
    if (empty(trim($reason))) {
        $reason = 'Documentación o información insuficiente.';
    }
    $result = $controller->rejectPermit($permitId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../permit_verifications.php');
exit;
?>