<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminPropertyController.php';

$controller = new AdminPropertyController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['property_id'])) {
    header('Location: ../property_verifications.php');
    exit;
}

$action = $_POST['action'];
$propertyId = $_POST['property_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approveProperty($propertyId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Documentación incorrecta o incompleta.';
    if (empty(trim($reason))) {
        $reason = 'Documentación incorrecta o incompleta.';
    }
    $result = $controller->rejectProperty($propertyId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../property_verifications.php');
exit;
?>