<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminReportController.php';

$controller = new AdminReportController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['report_id'])) {
    header('Location: ../citizen_reports.php');
    exit;
}

$action = $_POST['action'];
$reportId = $_POST['report_id'];
$result = null;

if ($action === 'update_status') {
    $newStatus = $_POST['new_status'] ?? 'open';
    // Validar que el estado sea uno de los permitidos
    $allowedStatus = ['open', 'in_progress', 'resolved', 'closed'];
    if (in_array($newStatus, $allowedStatus)) {
        $result = $controller->updateReportStatus($reportId, $newStatus);
    } else {
        $result = ['success' => false, 'message' => 'Estado no válido.'];
    }
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

// Redirigir de vuelta a la lista de reportes
header('Location: ../citizen_reports.php');
exit;
?>