<?php
require_once '../../config/config.php';
requireAdmin();
// Proteger esta acción solo para Super Admin
require_once '../controllers/AdminRoleController.php';

$controller = new AdminRoleController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'update_permissions') {
        $roleId = $_POST['role_id'];
        $permissionIds = $_POST['permissions'] ?? [];
        
        $result = $controller->updateRolePermissions($roleId, $permissionIds);
        setAlert($result['message'], $result['success'] ? 'success' : 'error');
        header('Location: ../role_form.php?id=' . $roleId);
        exit;
    }
}

header('Location: ../roles.php');
exit;