<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminUserController.php';

$controller = new AdminUserController();
$action = $_GET['action'] ?? null;
$userId = $_GET['id'] ?? null;

if ($userId && is_numeric($userId)) {
    if ($action === 'activate') {
        $result = $controller->updateUserStatus($userId, 1);
    } elseif ($action === 'deactivate') {
        $result = $controller->updateUserStatus($userId, 0);
    } else {
        $result = ['success' => false, 'message' => 'Acción no válida.'];
    }

    setAlert($result['message'], $result['success'] ? 'success' : 'error');
    // Redirigir de vuelta a la página de detalles del usuario
    header('Location: ../user_details.php?id=' . $userId);

} else {
    setAlert('ID de usuario no válido.', 'error');
    header('Location: ../users.php');
}
exit;
?>