<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/AdminVehicleController.php';

$controller = new AdminVehicleController();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action']) || !isset($_POST['vehicle_id'])) {
    header('Location: ../vehicle_verifications.php');
    exit;
}

$action = $_POST['action'];
$vehicleId = $_POST['vehicle_id'];
$result = null;

if ($action === 'approve') {
    $result = $controller->approveVehicle($vehicleId);
} elseif ($action === 'reject') {
    $reason = $_POST['rejection_reason'] ?? 'Documentación incorrecta o incompleta.';
    if (empty($reason)) {
        $reason = 'Documentación incorrecta o incompleta.';
    }
    $result = $controller->rejectVehicle($vehicleId, $reason);
}

if ($result) {
    setAlert($result['message'], $result['success'] ? 'success' : 'error');
} else {
    setAlert('Acción desconocida o inválida.', 'error');
}

header('Location: ../vehicle_verifications.php');
exit;
?>