<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/TaxController.php';

$controller = new TaxController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    $action = $_POST['action'];
    $data = $_POST; // Aquí ya viene incluido el 'property_id' si fue seleccionado
    
    if ($action === 'save_tax') {
        // Aquí irían validaciones más robustas de los datos
        
        if (empty($data['tax_id'])) {
            // Crear nuevo impuesto
            $result = $controller->createTax($data);
            $message = $result ? 'Impuesto asignado exitosamente.' : 'Error al asignar el impuesto.';
        } else {
            // Lógica para actualizar (la implementaremos más adelante)
            $result = true; // Simulado por ahora
            $message = 'Funcionalidad de actualizar aún no implementada.';
        }
        
        setAlert($message, $result ? 'success' : 'error');
        header('Location: ../taxes.php');
        exit;
    }
}

// Redirigir si no hay acción
header('Location: ../taxes.php');
exit;
?>