<?php
require_once '../../config/config.php';
requireAdmin();
require_once '../controllers/TaxConceptController.php';

$controller = new TaxConceptController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    $action = $_POST['action'];
    $data = $_POST;
    
    if ($action === 'save') {
        if (empty($data['id'])) {
            // Crear nuevo
            $result = $controller->create($data);
            $message = $result ? 'Concepto creado exitosamente.' : 'Error al crear el concepto.';
        } else {
            // Actualizar existente
            $result = $controller->update($data['id'], $data);
            $message = $result ? 'Concepto actualizado exitosamente.' : 'Error al actualizar el concepto.';
        }
        
        // Redirigir con un mensaje
        setAlert($message, $result ? 'success' : 'error');
        header('Location: ../tax_concepts.php');
        exit;
    }
}

// Redirigir si no hay acción
header('Location: ../tax_concepts.php');
exit;
?>