<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminActivityController.php';

$currentPage = 'activity_verifications';
$controller = new AdminActivityController();
$activityId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$activityId || !($activity = $controller->getActivityDetails($activityId))) {
    setAlert('Actividad económica no encontrada.', 'error');
    header('Location: activity_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles de Actividad Económica - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Revisión de Actividad: <?php echo htmlspecialchars($activity['activity_code']); ?></h1>
        </header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información del Contribuyente</h2>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($activity['document_number']); ?></p>
                    <p><strong>Razón Social:</strong> <?php echo htmlspecialchars($activity['company_name'] ?: $activity['first_name'] . ' ' . $activity['last_name']); ?></p>
                    
                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Datos de la Actividad</h2>
                    <p><strong>Código:</strong> <?php echo htmlspecialchars($activity['activity_code']); ?></p>
                    <p><strong>Descripción:</strong> <?php echo htmlspecialchars($activity['description']); ?></p>
                </div>
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Documento Adjunto</h2>
                    <?php if ($activity['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($activity['file_path']); ?>" target="_blank" class="text-blue-600 hover:underline flex items-center">
                            <i class="fas fa-file-pdf mr-2"></i> <?php echo htmlspecialchars($activity['file_name']); ?>
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó ningún documento.</p>
                    <?php endif; ?>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Acciones</h2>
                    <form action="actions/admin_activity_actions.php" method="POST">
                        <input type="hidden" name="activity_id" value="<?php echo $activity['id']; ?>">
                        
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium text-gray-700">Motivo del Rechazo (si aplica)</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>

                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg hover:bg-green-700 transition">
                                <i class="fas fa-check-circle mr-2"></i>Aprobar Actividad
                            </button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg hover:bg-red-700 transition">
                                <i class="fas fa-times-circle mr-2"></i>Rechazar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>