<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminAdvertisementController.php';

$currentPage = 'advertisement_verifications';
$controller = new AdminAdvertisementController();
$adId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$adId || !($ad = $controller->getAdvertisementDetails($adId))) {
    setAlert('Anuncio no encontrado.', 'error');
    header('Location: advertisement_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles de Publicidad - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Revisión de Anuncio Publicitario</h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Detalles</h2>
                    <p><strong>Contribuyente:</strong> <?php echo htmlspecialchars($ad['company_name'] ?: $ad['first_name'] . ' ' . $ad['last_name']); ?></p>
                    <p><strong>Tipo:</strong> <?php echo htmlspecialchars($ad['ad_type']); ?></p>
                    <p><strong>Dimensiones:</strong> <?php echo htmlspecialchars($ad['dimensions']); ?></p>
                    <p><strong>Ubicación:</strong> <?php echo htmlspecialchars($ad['location']); ?></p>
                    <p class="mt-4"><strong>Descripción:</strong><br><?php echo nl2br(htmlspecialchars($ad['description'])); ?></p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Documento Adjunto</h2>
                    <?php if ($ad['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($ad['file_path']); ?>" target="_blank" class="text-blue-600 hover:underline flex items-center">
                            <i class="fas fa-file-alt mr-2"></i> <?php echo htmlspecialchars($ad['file_name']); ?>
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó documento.</p>
                    <?php endif; ?>
                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Acciones</h2>
                    <form action="actions/admin_advertisement_actions.php" method="POST">
                        <input type="hidden" name="ad_id" value="<?php echo $ad['id']; ?>">
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium">Motivo del Rechazo</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>
                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg">Aprobar Anuncio</button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg">Rechazar</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>