<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminAdvertisementController.php';

$currentPage = 'advertisement_verifications';
$controller = new AdminAdvertisementController();
$pendingAds = $controller->getPendingAdvertisements();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Verificación de Publicidad - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Publicidad Pendiente de Verificación</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Tipo</th>
                            <th class="p-3 text-left">Descripción</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pendingAds)): ?>
                            <tr><td colspan="5" class="p-4 text-center text-gray-500">No hay anuncios pendientes por verificar.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pendingAds as $ad): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($ad['created_at']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($ad['company_name'] ?: $ad['first_name'] . ' ' . $ad['last_name']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($ad['ad_type']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($ad['description']); ?></td>
                                    <td class="p-3 text-center">
                                        <a href="advertisement_details.php?id=<?php echo $ad['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">Revisar</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>