<?php
// Este script actúa como un endpoint de API para devolver los inmuebles de un usuario en formato JSON.
require_once '../../config/config.php';
requireAdmin(); // Asegura que solo un admin pueda acceder a esta información

header('Content-Type: application/json');

$userId = filter_input(INPUT_GET, 'user_id', FILTER_VALIDATE_INT);

if (!$userId) {
    echo json_encode(['success' => false, 'message' => 'ID de usuario no válido.']);
    exit;
}

$db = Database::getInstance();
// Buscamos solo los inmuebles que ya han sido verificados por catastro
$stmt = $db->query(
    "SELECT id, cadastral_code, address FROM properties WHERE user_id = ? AND status = 'verified'",
    [$userId]
);

$properties = $stmt->fetchAll();

echo json_encode(['success' => true, 'properties' => $properties]);
exit;
?>