// Función para ocultar o mostrar el menú lateral (sidebar)
function toggleSidebar() {
    const sidebar = document.querySelector('.sidebar');
    if (sidebar) {
        sidebar.classList.toggle('collapsed');
    }
}

// Lógica para el menú acordeón (CORREGIDA Y MEJORADA)
document.addEventListener('DOMContentLoaded', function () {
    const accordionHeaders = document.querySelectorAll('.accordion-header');

    // Al cargar la página, abre la sección que ya está activa (definida por PHP)
    const activeHeaderOnLoad = document.querySelector('.accordion-header.active');
    if (activeHeaderOnLoad) {
        const content = activeHeaderOnLoad.nextElementSibling;
        content.style.maxHeight = content.scrollHeight + "px";
    }

    // Maneja los clics en los encabezados del acordeón
    accordionHeaders.forEach(header => {
        header.addEventListener('click', function () {
            const content = this.nextElementSibling;
            const isCurrentlyActive = this.classList.contains('active');

            // Cierra todos los demás acordeones
            accordionHeaders.forEach(otherHeader => {
                if (otherHeader !== this) {
                    otherHeader.classList.remove('active');
                    otherHeader.nextElementSibling.style.maxHeight = null;
                }
            });

            // Abre o cierra el acordeón actual
            if (isCurrentlyActive) {
                this.classList.remove('active');
                content.style.maxHeight = null;
            } else {
                this.classList.add('active');
                content.style.maxHeight = content.scrollHeight + "px";
            }
        });
    });
});


// Lógica para las páginas de monedas 
function openAddCurrencyModal() {
    alert('Funcionalidad para añadir moneda aún no implementada.');
}

function openEditCurrencyModal(currencyCode) {
    alert(`Funcionalidad para editar ${currencyCode} aún no implementada.`);
}

function setDefaultCurrency(currencyCode) {
    if (confirm(`¿Está seguro de que desea establecer ${currencyCode} como moneda predeterminada?`)) {
        alert(`Funcionalidad para establecer ${currencyCode} como predeterminada aún no implementada.`);
    }
}

function updateAllRates() {
    if (confirm('¿Desea actualizar todas las tasas de cambio desde la fuente de datos (ej. BCV)?')) {
        alert('Funcionalidad para actualizar tasas aún no implementada.');
    }
}