<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminReportController.php';

$currentPage = 'citizen_reports';
$controller = new AdminReportController();
$reports = $controller->getAllReports();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Gestión de Reportes Ciudadanos - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Gestión de Reportes Ciudadanos</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha</th>
                            <th class="p-3 text-left">Título</th>
                            <th class="p-3 text-left">Categoría</th>
                            <th class="p-3 text-left">Reportado por</th>
                            <th class="p-3 text-center">Estado</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($reports)): ?>
                            <tr><td colspan="6" class="p-4 text-center text-gray-500">No hay reportes ciudadanos.</td></tr>
                        <?php else: ?>
                            <?php foreach ($reports as $report): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($report['created_at']); ?></td>
                                    <td class="p-3 text-sm font-semibold"><?php echo htmlspecialchars($report['title']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($report['category']); ?></td>
                                    <td class="p-3 text-sm">
                                        <?php echo htmlspecialchars($report['company_name'] ?: $report['first_name'] . ' ' . $report['last_name']); ?><br>
                                        <small class="font-mono"><?php echo htmlspecialchars($report['document_number']); ?></small>
                                    </td>
                                    <td class="p-3 text-center">
                                         <?php
                                            $statusText = ''; $statusColor = '';
                                            switch ($report['status']) {
                                                case 'open': $statusText = 'Abierto'; $statusColor = 'bg-blue-100 text-blue-800'; break;
                                                case 'in_progress': $statusText = 'En Progreso'; $statusColor = 'bg-yellow-100 text-yellow-800'; break;
                                                case 'resolved': $statusText = 'Resuelto'; $statusColor = 'bg-green-100 text-green-800'; break;
                                                case 'closed': $statusText = 'Cerrado'; $statusColor = 'bg-gray-100 text-gray-800'; break;
                                            }
                                        ?>
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo $statusColor; ?>">
                                            <?php echo $statusText; ?>
                                        </span>
                                    </td>
                                    <td class="p-3 text-center">
                                        <a href="report_details.php?id=<?php echo $report['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">
                                            <i class="fas fa-search mr-1"></i>Ver Detalles
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>