<?php
class AdminRoleController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function getAllRoles() {
        return $this->db->query("SELECT * FROM roles WHERE id != 99 ORDER BY name")->fetchAll();
    }

    public function getRoleById($roleId) {
        return $this->db->query("SELECT * FROM roles WHERE id = ?", [$roleId])->fetch();
    }

    public function getAllPermissions() {
        return $this->db->query("SELECT * FROM permissions ORDER BY name")->fetchAll();
    }

    public function getRolePermissions($roleId) {
        $stmt = $this->db->query("SELECT permission_id FROM role_permissions WHERE role_id = ?", [$roleId]);
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }

    public function updateRolePermissions($roleId, $permissionIds) {
        // Iniciar transacción
        $this->db->getConnection()->beginTransaction();
        try {
            // Borrar permisos antiguos
            $this->db->query("DELETE FROM role_permissions WHERE role_id = ?", [$roleId]);

            // Insertar nuevos permisos
            if (!empty($permissionIds)) {
                $sql = "INSERT INTO role_permissions (role_id, permission_id) VALUES ";
                $params = [];
                $rows = [];
                foreach ($permissionIds as $permId) {
                    $rows[] = "(?, ?)";
                    $params[] = $roleId;
                    $params[] = $permId;
                }
                $sql .= implode(", ", $rows);
                $this->db->query($sql, $params);
            }

            // Confirmar transacción
            $this->db->getConnection()->commit();
            logActivity('role_permissions_updated', 'roles', $roleId);
            return ['success' => true, 'message' => 'Permisos del rol actualizados exitosamente.'];

        } catch (Exception $e) {
            $this->db->getConnection()->rollBack();
            error_log($e->getMessage());
            return ['success' => false, 'message' => 'Error al actualizar los permisos del rol.'];
        }
    }
}
?>