<?php
class AdminUserController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene todos los usuarios con rol 'citizen'.
     * @return array Lista de usuarios.
     */
    public function getAllCitizens() {
        // --- CORRECCIÓN EN LA CONSULTA SQL ---
        // Se cambió "WHERE role = 'citizen'" por "WHERE role_id = 99"
        $sql = "SELECT id, user_type, document_number, email, first_name, last_name, company_name, is_active, created_at 
                FROM users 
                WHERE role_id = 99 
                ORDER BY created_at DESC";
        
        $stmt = $this->db->query($sql);
        // Añadimos una comprobación para evitar errores si la consulta falla
        return $stmt ? $stmt->fetchAll() : [];
    }

    /**
     * Obtiene los detalles completos de un usuario específico.
     * @param int $userId El ID del usuario.
     * @return array|false Los datos del usuario o false si no se encuentra.
     */
    public function getUserDetails($userId) {
        $stmt = $this->db->query("SELECT * FROM users WHERE id = ?", [$userId]);
        return $stmt->fetch();
    }

    /**
     * Cambia el estado de activación de un usuario.
     * @param int $userId El ID del usuario.
     * @param int $status El nuevo estado (1 para activo, 0 para inactivo).
     * @return array Resultado de la operación.
     */
    public function updateUserStatus($userId, $status) {
        $newStatus = ($status == 1) ? 1 : 0;
        
        $sql = "UPDATE users SET is_active = ? WHERE id = ?";
        $stmt = $this->db->query($sql, [$newStatus, $userId]);

        if ($stmt) {
            $statusText = $newStatus == 1 ? 'activada' : 'desactivada';
            logActivity('user_status_changed', 'users', $userId, null, ['is_active' => $newStatus]);
            return ['success' => true, 'message' => 'La cuenta del contribuyente ha sido ' . $statusText . '.'];
        }
        return ['success' => false, 'message' => 'Error al actualizar el estado de la cuenta.'];
    }
}
?>