<?php
class DashboardController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function getDashboardStats() {
        $stats = [];

        // Función auxiliar para ejecutar conteos de forma segura
        $fetchCount = function($sql) {
            $stmt = $this->db->query($sql);
            // Si la consulta es exitosa, devuelve el total, si no, devuelve 0.
            return $stmt ? ($stmt->fetch()['total'] ?? 0) : 0;
        };

        // Recaudación del mes (más seguro)
        $stmt_revenue = $this->db->query("SELECT SUM(amount) as total FROM payments WHERE status = 'verified' AND MONTH(verified_at) = MONTH(CURRENT_DATE()) AND YEAR(verified_at) = YEAR(CURRENT_DATE())");
        $stats['monthly_revenue'] = $stmt_revenue ? ($stmt_revenue->fetch()['total'] ?? 0) : 0;

        // Estadísticas principales
        $stats['pending_payments'] = $fetchCount("SELECT COUNT(*) as total FROM payments WHERE status = 'pending'");
        $stats['total_citizens'] = $fetchCount("SELECT COUNT(*) as total FROM users WHERE role_id = 99");
        
        // Verificaciones pendientes
        $stats['pending_vehicles'] = $fetchCount("SELECT COUNT(*) as total FROM vehicles WHERE status = 'pending_verification'");
        $stats['pending_properties'] = $fetchCount("SELECT COUNT(*) as total FROM properties WHERE status = 'pending_verification'");
        $stats['pending_activities'] = $fetchCount("SELECT COUNT(*) as total FROM economic_activities WHERE status = 'pending_verification'");
        $stats['pending_ads'] = $fetchCount("SELECT COUNT(*) as total FROM advertisements WHERE status = 'pending_verification'");
        
        return $stats;
    }
}
?>