<?php
class ReportController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Genera un reporte de contribuyentes con deudas vencidas.
     * Agrupa todas las deudas vencidas por usuario.
     * @return array Lista de contribuyentes morosos y el total de su deuda.
     */
    public function getDefaultersReport() {
        $this->db->query("UPDATE taxes SET status = 'overdue' WHERE due_date < CURDATE() AND status = 'pending'");

        $sql = "SELECT 
                    u.id as user_id,
                    u.document_number,
                    u.company_name,
                    u.first_name,
                    u.last_name,
                    u.email,
                    u.phone,
                    COUNT(t.id) as overdue_taxes_count,
                    SUM(t.amount) as total_debt
                FROM users u
                JOIN taxes t ON u.id = t.user_id
                WHERE t.status = 'overdue'
                GROUP BY u.id
                ORDER BY total_debt DESC";
        
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    /**
     * Genera un reporte de recaudación de impuestos por rango de fechas.
     * @param string $startDate Fecha de inicio (Y-m-d).
     * @param string $endDate Fecha de fin (Y-m-d).
     * @return array Lista de pagos verificados en el rango de fechas.
     */
    public function getTaxCollectionReport($startDate, $endDate) {
        $sql = "SELECT
                    p.id,
                    p.verified_at,
                    p.amount,
                    p.reference_number,
                    c.symbol as currency_symbol,
                    tc.name as tax_concept,
                    u.document_number,
                    u.company_name,
                    u.first_name,
                    u.last_name
                FROM payments p
                JOIN users u ON p.user_id = u.id
                JOIN taxes t ON p.tax_id = t.id
                JOIN tax_concepts tc ON t.tax_concept_id = tc.id
                JOIN currencies c ON p.currency_id = c.id
                WHERE p.status = 'verified'
                AND DATE(p.verified_at) BETWEEN ? AND ?
                ORDER BY p.verified_at ASC";

        $stmt = $this->db->query($sql, [$startDate, $endDate]);
        return $stmt->fetchAll();
    }
}
?>