<?php
class SettingsController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene todas las configuraciones del sistema.
     * @return array Un array asociativo con config_key => config_value.
     */
    public function getAllSettings() {
        $stmt = $this->db->query("SELECT config_key, config_value FROM system_config");
        $config = [];
        while ($row = $stmt->fetch()) {
            $config[$row['config_key']] = $row['config_value'];
        }
        return $config;
    }

    /**
     * Guarda un conjunto de configuraciones en la base de datos.
     * @param array $data Los datos a guardar ($_POST).
     * @param array $files Los archivos a subir ($_FILES).
     */
    public function saveSettings($data, $files) {
        // Manejar la subida del logo
        if (isset($files['site_logo']) && $files['site_logo']['error'] === UPLOAD_ERR_OK) {
            $uploadResult = uploadFile($files['site_logo'], 'logos');
            if ($uploadResult['success']) {
                // Si la subida fue exitosa, guardamos la RUTA del archivo en la configuración
                $data['site_logo'] = $uploadResult['path'];
            } else {
                // Si falla, es buena idea notificarlo, pero no detenemos el guardado de otros datos.
                setAlert('Error al subir el logo: ' . $uploadResult['message'], 'error');
            }
        }

        foreach ($data as $key => $value) {
            $sql = "INSERT INTO system_config (config_key, config_value) VALUES (?, ?)
                    ON DUPLICATE KEY UPDATE config_value = ?";
            $this->db->query($sql, [$key, $value, $value]);
        }
        logActivity('settings_updated', 'system_config');
    }
}
?>