<?php
class TaxConceptController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function getAll() {
        $stmt = $this->db->query("SELECT * FROM tax_concepts ORDER BY name");
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->query("SELECT * FROM tax_concepts WHERE id = ?", [$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $sql = "INSERT INTO tax_concepts (name, description, aliquota, base_amount, calculation_method) VALUES (?, ?, ?, ?, ?)";
        $params = [
            $data['name'],
            $data['description'],
            empty($data['aliquota']) ? null : $data['aliquota'],
            empty($data['base_amount']) ? null : $data['base_amount'],
            $data['calculation_method']
        ];
        $stmt = $this->db->query($sql, $params);
        return $stmt ? $this->db->lastInsertId() : false;
    }

    public function update($id, $data) {
        $sql = "UPDATE tax_concepts SET name = ?, description = ?, aliquota = ?, base_amount = ?, calculation_method = ? WHERE id = ?";
        $params = [
            $data['name'],
            $data['description'],
            empty($data['aliquota']) ? null : $data['aliquota'],
            empty($data['base_amount']) ? null : $data['base_amount'],
            $data['calculation_method'],
            $id
        ];
        $stmt = $this->db->query($sql, $params);
        return $stmt !== false;
    }

    public function delete($id) {
        // Añadir validación para no borrar conceptos en uso
        $stmt = $this->db->query("DELETE FROM tax_concepts WHERE id = ?", [$id]);
        return $stmt !== false;
    }
}
?>