<?php
class TaxController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene todos los impuestos asignados.
     * Une las tablas de impuestos, usuarios, monedas y conceptos para mostrar información completa.
     * @return array Lista de impuestos.
     */
    public function getAllTaxes() {
        $sql = "SELECT 
                    t.id, t.amount, t.status, t.due_date,
                    u.document_number AS user_document,
                    c.code AS currency_code,
                    tc.name AS tax_type 
                FROM taxes t
                JOIN users u ON t.user_id = u.id
                JOIN currencies c ON t.currency_id = c.id
                JOIN tax_concepts tc ON t.tax_concept_id = tc.id
                ORDER BY t.created_at DESC";
        
        $stmt = $this->db->query($sql);
        if ($stmt === false) {
            error_log("Error en la consulta SQL para obtener impuestos.");
            return [];
        }
        return $stmt->fetchAll();
    }

    /**
     * Crea una nueva asignación de impuesto para un usuario.
     * @param array $data Datos del formulario.
     * @return mixed El ID del nuevo impuesto si tiene éxito, false si falla.
     */
    public function createTax($data) {
        // ---- INICIO DE LA ACTUALIZACIÓN ----
        // Preparamos el property_id. Si está vacío o no se envió, se guardará como NULL.
        $propertyId = !empty($data['property_id']) ? $data['property_id'] : null;

        $sql = "INSERT INTO taxes (user_id, tax_concept_id, property_id, description, amount, currency_id, due_date, status) 
                VALUES (?, ?, ?, ?, ?, ?, ?, 'pending')";
        
        $params = [
            $data['user_id'],
            $data['tax_concept_id'],
            $propertyId, // Añadimos el nuevo parámetro
            $data['description'],
            $data['amount'],
            $data['currency_id'],
            $data['due_date']
        ];
        // ---- FIN DE LA ACTUALIZACIÓN ----

        $stmt = $this->db->query($sql, $params);

        return $stmt ? $this->db->lastInsertId() : false;
    }
}
?>