<?php
require_once '../config/config.php';
requireAdmin();
$currentPage = 'currencies'; // Definimos la página actual para el menú
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale-1.0">
    <title>Gestión de Monedas - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css"> </head>
<body class="bg-gray-100">
    
    <?php include 'partials/sidebar.php'; // Menú lateral centralizado ?>

    <div class="main-content min-h-screen">
        <header class="bg-white shadow-sm border-b">
            <div class="flex items-center justify-between p-4">
                <button onclick="toggleSidebar()" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-bars text-gray-600"></i></button>
                <div class="flex items-center space-x-4">
                    <?php $user = $auth->getUser(); ?>
                    <span class="text-sm font-medium"><?php echo htmlspecialchars($user['first_name'] ?? 'Admin'); ?></span>
                    <i class="fas fa-user-circle text-2xl text-gray-500"></i>
                </div>
            </div>
        </header>

        <main class="p-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Gestión de Monedas</h1>
                    <p class="text-gray-600">Configuración del sistema multimoneda</p>
                </div>
                <div class="flex space-x-3">
                    <button onclick="updateAllRates()" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                        <i class="fas fa-sync mr-2"></i>Actualizar Tasas
                    </button>
                    <button onclick="openAddCurrencyModal()" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition">
                        <i class="fas fa-plus mr-2"></i>Nueva Moneda
                    </button>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <?php
                $currencies = $currency->getAllCurrencies();
                foreach ($currencies as $curr): 
                    $isDefault = $curr['is_default'];
                ?>
                <div class="currency-card bg-white rounded-xl p-6 shadow-sm border <?php echo $isDefault ? 'border-2 border-purple-500' : 'border-gray-200'; ?>">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="bg-purple-100 text-purple-600 p-3 rounded-lg">
                                <span class="text-xl font-bold"><?php echo htmlspecialchars($curr['symbol']); ?></span>
                            </div>
                            <div>
                                <h3 class="font-bold text-gray-800"><?php echo htmlspecialchars($curr['name']); ?> (<?php echo htmlspecialchars($curr['code']); ?>)</h3>
                                <p class="text-sm text-gray-600"><?php echo $isDefault ? 'Moneda principal' : 'Moneda secundaria'; ?></p>
                            </div>
                        </div>
                        <?php if ($isDefault): ?>
                        <span class="bg-purple-100 text-purple-600 px-2 py-1 rounded-full text-xs font-bold">
                            PREDETERMINADA
                        </span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="space-y-3 mb-4">
                        <div class="flex justify-between text-sm"><span>Tasa de cambio:</span><span class="font-bold"><?php echo number_format($curr['exchange_rate'], 6); ?></span></div>
                        <div class="flex justify-between text-sm"><span>Estado:</span><span class="<?php echo $curr['is_active'] ? 'text-green-600' : 'text-red-600'; ?> font-bold"><?php echo $curr['is_active'] ? 'Activa' : 'Inactiva'; ?></span></div>
                        <div class="flex justify-between text-sm"><span>Última actualización:</span><span class="text-gray-600"><?php echo $curr['last_update'] ? date('d/m/Y H:i', strtotime($curr['last_update'])) : 'Nunca'; ?></span></div>
                    </div>

                    <div class="flex space-x-2">
                        <?php if (!$isDefault): ?>
                        <button onclick="openEditCurrencyModal('<?php echo $curr['code']; ?>')" class="flex-1 bg-blue-100 text-blue-600 py-2 rounded-lg hover:bg-blue-200 transition text-sm"><i class="fas fa-edit mr-1"></i>Editar</button>
                        <button onclick="setDefaultCurrency('<?php echo $curr['code']; ?>')" class="flex-1 bg-purple-100 text-purple-600 py-2 rounded-lg hover:bg-purple-200 transition text-sm"><i class="fas fa-star mr-1"></i>Predeterminar</button>
                        <?php else: ?>
                        <button class="flex-1 bg-gray-100 text-gray-600 py-2 rounded-lg text-sm" disabled><i class="fas fa-edit mr-1"></i>Editar</button>
                        <button class="flex-1 bg-gray-100 text-gray-600 py-2 rounded-lg text-sm" disabled><i class="fas fa-star mr-1"></i>Predeterminar</button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </main>
    </div>

    <script src="assets/js/main.js"></script>
</body>
</html>