<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminFiscalizationController.php';

$currentPage = 'fiscalization';
$controller = new AdminFiscalizationController();
$audits = $controller->getAllAudits();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Módulo de Fiscalización - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4 flex justify-between items-center">
            <h1 class="text-xl font-bold">Módulo de Fiscalización</h1>
            <a href="fiscalization_form.php" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">
                <i class="fas fa-plus mr-2"></i>Nueva Fiscalización
            </a>
        </header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha Visita</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Fiscal</th>
                            <th class="p-3 text-center">Estado</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($audits)): ?>
                            <tr><td colspan="5" class="p-4 text-center text-gray-500">No hay fiscalizaciones registradas.</td></tr>
                        <?php else: ?>
                            <?php foreach ($audits as $audit): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDate($audit['visit_date']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($audit['company_name'] ?: $audit['first_name'] . ' ' . $audit['last_name']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($audit['fiscal_first_name'] . ' ' . $audit['fiscal_last_name']); ?></td>
                                    <td class="p-3 text-center">
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo $audit['status'] == 'pending_fine' ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800'; ?>">
                                            <?php echo $audit['status'] == 'pending_fine' ? 'Con Multas' : 'Completada'; ?>
                                        </span>
                                    </td>
                                    <td class="p-3 text-center">
                                        <a href="#" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">Ver Detalles</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>