<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminFiscalizationController.php';

$currentPage = 'fiscalization';
$controller = new AdminFiscalizationController();
$infractionTypes = $controller->getInfractionTypes();
$users = $db->query("SELECT id, document_number, first_name, last_name, company_name FROM users WHERE role = 'citizen' ORDER BY document_number")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Registrar Fiscalización - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-md border-b p-4"><h1 class="text-xl font-bold">Registrar Nueva Fiscalización</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md p-8 max-w-4xl mx-auto">
                <form action="actions/admin_fiscalization_actions.php" method="POST">
                    <input type="hidden" name="action" value="create_audit">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="user_id" class="block text-sm font-medium text-gray-700 mb-2">Contribuyente</label>
                            <select name="user_id" id="user_id" class="w-full form-select" required>
                                <option value="">Seleccione...</option>
                                <?php foreach ($users as $user): ?>
                                    <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['document_number'] . ' - ' . ($user['company_name'] ?: $user['first_name'] . ' ' . $user['last_name'])); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="visit_date" class="block text-sm font-medium text-gray-700 mb-2">Fecha de Visita</label>
                            <input type="date" name="visit_date" id="visit_date" class="w-full form-input" required>
                        </div>
                        <div class="md:col-span-2">
                            <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Notas y Observaciones de la Visita</label>
                            <textarea name="notes" id="notes" rows="4" class="w-full form-input" placeholder="Describa los hallazgos de la fiscalización..."></textarea>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Infracciones Detectadas (Opcional)</label>
                            <div class="space-y-2 max-h-48 overflow-y-auto border p-3 rounded-lg">
                                <?php foreach ($infractionTypes as $infraction): ?>
                                <label class="flex items-center">
                                    <input type="checkbox" name="infractions[]" value="<?php echo $infraction['id']; ?>" class="rounded">
                                    <span class="ml-2 text-sm"><?php echo htmlspecialchars($infraction['code'] . ' - ' . $infraction['description']); ?></span>
                                </label>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="mt-8 pt-6 border-t flex justify-end">
                        <a href="fiscalization.php" class="btn-secondary mr-3">Cancelar</a>
                        <button type="submit" class="btn-primary"><i class="fas fa-save mr-2"></i>Guardar Fiscalización</button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>