<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/DashboardController.php';

$currentPage = 'dashboard';
$controller = new DashboardController();
$stats = $controller->getDashboardStats();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Administración - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-gray-100">

    <?php include 'partials/sidebar.php'; ?>

    <div class="main-content min-h-screen">
        <header class="bg-white shadow-sm border-b">
            <div class="flex items-center justify-between p-4">
                <button onclick="toggleSidebar()" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-bars text-gray-600"></i></button>
                <div class="flex items-center space-x-4">
                    <?php $user = $auth->getUser(); ?>
                    <span class="text-sm font-medium"><?php echo htmlspecialchars($user['first_name'] ?? 'Admin'); ?></span>
                    <i class="fas fa-user-circle text-2xl text-gray-500"></i>
                </div>
            </div>
        </header>

        <main class="p-6">
            <div class="mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Dashboard Principal</h1>
                <p class="text-gray-600">Resumen general del sistema municipal</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Recaudación del Mes</span>
                        <div class="bg-green-100 text-green-600 p-2 rounded-lg"><i class="fas fa-money-bill-wave"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2">Bs. <?php echo number_format($stats['monthly_revenue'], 2); ?></div>
                </div>
                
                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Pagos por Conciliar</span>
                        <div class="bg-yellow-100 text-yellow-600 p-2 rounded-lg"><i class="fas fa-hourglass-half"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['pending_payments']; ?></div>
                </div>

                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Total Contribuyentes</span>
                        <div class="bg-purple-100 text-purple-600 p-2 rounded-lg"><i class="fas fa-users"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['total_citizens']; ?></div>
                </div>
            </div>

            <div class="mb-6">
                <h2 class="text-xl font-bold text-gray-800">Verificaciones Pendientes</h2>
                <p class="text-gray-600">Solicitudes que requieren su atención</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                 <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Vehículos</span>
                        <div class="bg-blue-100 text-blue-600 p-2 rounded-lg"><i class="fas fa-car"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['pending_vehicles']; ?></div>
                </div>
                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Inmuebles</span>
                        <div class="bg-indigo-100 text-indigo-600 p-2 rounded-lg"><i class="fas fa-home"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['pending_properties']; ?></div>
                </div>
                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Actividades Económicas</span>
                        <div class="bg-pink-100 text-pink-600 p-2 rounded-lg"><i class="fas fa-store"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['pending_activities']; ?></div>
                </div>
                <div class="stat-card bg-white rounded-xl p-6 shadow-sm border">
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Publicidad</span>
                        <div class="bg-red-100 text-red-600 p-2 rounded-lg"><i class="fas fa-ad"></i></div>
                    </div>
                    <div class="text-3xl font-bold text-gray-800 mt-2"><?php echo $stats['pending_ads']; ?></div>
                </div>
            </div>
            
        </main>
    </div>

    <script src="assets/js/main.js"></script>
</body>
</html>