<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminLicenseController.php';

$currentPage = 'license_verifications';
$controller = new AdminLicenseController();
$licenseId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$licenseId || !($license = $controller->getLicenseDetails($licenseId))) {
    setAlert('Solicitud de licencia no encontrada.', 'error');
    header('Location: license_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles de Solicitud de Licencia - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Revisión de Solicitud de Licencia</h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información de la Solicitud</h2>
                    <p><strong>Contribuyente:</strong> <?php echo htmlspecialchars($license['company_name'] ?: $license['first_name'] . ' ' . $license['last_name']); ?></p>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($license['document_number']); ?></p>
                    <p><strong>Actividad Económica:</strong> <?php echo htmlspecialchars($license['activity_code'] . ' - ' . $license['activity_description']); ?></p>
                    <p><strong>Fecha de Solicitud:</strong> <?php echo formatDateTime($license['request_date']); ?></p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Acciones</h2>
                    <form action="actions/admin_license_actions.php" method="POST">
                        <input type="hidden" name="license_id" value="<?php echo $license['id']; ?>">
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium">Motivo del Rechazo (si aplica)</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>
                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg">Aprobar Licencia</button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg">Rechazar Solicitud</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>