<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminLicenseController.php';

$currentPage = 'license_verifications';
$controller = new AdminLicenseController();
$pendingLicenses = $controller->getPendingLicenses();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Verificación de Licencias - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Solicitudes de Licencia Pendientes</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha Solicitud</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Actividad Económica</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pendingLicenses)): ?>
                            <tr><td colspan="4" class="p-4 text-center text-gray-500">No hay solicitudes de licencia pendientes.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pendingLicenses as $license): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($license['request_date']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($license['company_name'] ?: $license['first_name'] . ' ' . $license['last_name']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($license['activity_description']); ?></td>
                                    <td class="p-3 text-center">
                                        <a href="license_details.php?id=<?php echo $license['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">Revisar</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>