<?php
$currentPage = $currentPage ?? '';
?>
<div class="sidebar fixed h-screen bg-gray-900 text-white shadow-lg overflow-y-auto">
    <div class="p-6 border-b border-gray-800">
        <div class="flex items-center space-x-3">
            <div class="bg-purple-600 p-2 rounded-lg"><i class="fas fa-building text-white text-xl"></i></div>
            <div class="sidebar-logo">
                <h2 class="text-xl font-bold">Sistema Municipal</h2>
                <p class="text-sm text-gray-400">Panel Admin</p>
            </div>
        </div>
    </div>
    <nav class="p-4 space-y-1">
        <a href="index.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'dashboard') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt w-6"></i>
            <span class="sidebar-text">Dashboard</span>
        </a>
        <a href="users.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'users') ? 'active' : ''; ?>">
            <i class="fas fa-users-cog w-6"></i>
            <span class="sidebar-text">Contribuyentes</span>
        </a>
        
        <p class="px-3 pt-4 pb-2 text-xs text-gray-500 uppercase sidebar-text">Gestión Financiera</p>
        <a href="fiscalization.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'fiscalization') ? 'active' : ''; ?>"><i class="fas fa-gavel w-6"></i><span class="sidebar-text">Fiscalización</span></a>
        <a href="payments.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'payments') ? 'active' : ''; ?>"><i class="fas fa-cash-register w-6"></i><span class="sidebar-text">Conciliación de Pagos</span></a>
        <a href="taxes.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'taxes') ? 'active' : ''; ?>"><i class="fas fa-file-invoice-dollar w-6"></i><span class="sidebar-text">Asignar Impuestos</span></a>
        <a href="tax_concepts.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'tax_concepts') ? 'active' : ''; ?>"><i class="fas fa-cogs w-6"></i><span class="sidebar-text">Conceptos Tributarios</span></a>
        <a href="currencies.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'currencies') ? 'active' : ''; ?>"><i class="fas fa-coins w-6"></i><span class="sidebar-text">Monedas</span></a>

        <p class="px-3 pt-4 pb-2 text-xs text-gray-500 uppercase sidebar-text">Verificaciones y Permisos</p>
        <a href="permit_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'permit_verifications') ? 'active' : ''; ?>"><i class="fas fa-hard-hat w-6"></i><span class="sidebar-text">Construcción</span></a>
        <a href="event_permit_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'event_permit_verifications') ? 'active' : ''; ?>"><i class="fas fa-calendar-check w-6"></i><span class="sidebar-text">Eventos y Varios</span></a>
        <a href="license_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'license_verifications') ? 'active' : ''; ?>"><i class="fas fa-file-contract w-6"></i><span class="sidebar-text">Licencias (Patentes)</span></a>
        <a href="vehicle_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'vehicle_verifications') ? 'active' : ''; ?>"><i class="fas fa-car-side w-6"></i><span class="sidebar-text">Vehículos</span></a>
        <a href="activity_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'activity_verifications') ? 'active' : ''; ?>"><i class="fas fa-store-alt w-6"></i><span class="sidebar-text">Act. Económicas</span></a>
        <a href="property_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'property_verifications') ? 'active' : ''; ?>"><i class="fas fa-map-marked-alt w-6"></i><span class="sidebar-text">Inmuebles</span></a>
        <a href="advertisement_verifications.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'advertisement_verifications') ? 'active' : ''; ?>"><i class="fas fa-ad w-6"></i><span class="sidebar-text">Publicidad</span></a>

        <p class="px-3 pt-4 pb-2 text-xs text-gray-500 uppercase sidebar-text">Administración</p>
        <?php if ($auth->hasPermission('manage_roles')): ?>
        <a href="roles.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'roles') ? 'active' : ''; ?>">
            <i class="fas fa-user-shield w-6"></i>
            <span class="sidebar-text">Roles y Permisos</span>
        </a>
        <?php endif; ?>
        <a href="citizen_reports.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'citizen_reports') ? 'active' : ''; ?>"><i class="fas fa-bullhorn w-6"></i><span class="sidebar-text">Reportes Ciudadanos</span></a>
        <a href="reports.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'reports') ? 'active' : ''; ?>"><i class="fas fa-chart-line w-6"></i><span class="sidebar-text">Generador de Reportes</span></a>
        <a href="settings.php" class="nav-item flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-800 transition <?php echo ($currentPage === 'settings') ? 'active' : ''; ?>"><i class="fas fa-tools w-6"></i><span class="sidebar-text">Configuración</span></a>
    </nav>
</div>