<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminPaymentController.php';

$currentPage = 'payments';
$controller = new AdminPaymentController();
$pendingPayments = $controller->getPendingPayments();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Conciliación de Pagos - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>

    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Pagos Pendientes de Conciliación</h1>
        </header>

        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha Reporte</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Concepto</th>
                            <th class="p-3 text-left">Monto</th>
                            <th class="p-3 text-left">Referencia</th>
                            <th class="p-3 text-center">Comprobante</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pendingPayments)): ?>
                            <tr><td colspan="7" class="p-4 text-center text-gray-500">No hay pagos pendientes por verificar.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pendingPayments as $payment): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($payment['created_at']); ?></td>
                                    <td class="p-3 text-sm">
                                        <?php echo htmlspecialchars($payment['document_number']); ?><br>
                                        <small><?php echo htmlspecialchars($payment['company_name'] ?: $payment['first_name'] . ' ' . $payment['last_name']); ?></small>
                                    </td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($payment['tax_concept']); ?></td>
                                    <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($payment['currency_symbol']) . ' ' . number_format($payment['amount'], 2); ?></td>
                                    <td class="p-3 text-sm">
                                        <?php echo htmlspecialchars($payment['bank_name']); ?><br>
                                        <small class="font-mono"><?php echo htmlspecialchars($payment['reference_number']); ?></small>
                                    </td>
                                    <td class="p-3 text-center">
                                        <?php if ($payment['receipt_url']): ?>
                                            <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($payment['receipt_url']); ?>" target="_blank" class="text-blue-500 hover:underline">
                                                <i class="fas fa-file-alt"></i> Ver
                                            </a>
                                        <?php else: ?>
                                            <span>N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-3 text-center space-x-2">
                                        <a href="actions/admin_payment_actions.php?action=approve&id=<?php echo $payment['id']; ?>" class="bg-green-500 text-white px-2 py-1 text-xs rounded hover:bg-green-600">Aprobar</a>
                                        <a href="actions/admin_payment_actions.php?action=reject&id=<?php echo $payment['id']; ?>" class="bg-red-500 text-white px-2 py-1 text-xs rounded hover:bg-red-600">Rechazar</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>