<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminPermitController.php';

$currentPage = 'permit_verifications';
$controller = new AdminPermitController();
$permitId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$permitId || !($permit = $controller->getPermitDetails($permitId))) {
    setAlert('Solicitud de permiso no encontrada.', 'error');
    header('Location: permit_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles de Solicitud de Permiso - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Revisión de Solicitud de Permiso</h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información de la Solicitud</h2>
                    <p><strong>Tipo de Permiso:</strong> <?php echo htmlspecialchars($permit['permit_name']); ?></p>
                    <p><strong>Fecha de Solicitud:</strong> <?php echo formatDateTime($permit['application_date']); ?></p>
                    <p><strong>Inmueble Asociado:</strong> <?php echo htmlspecialchars($permit['cadastral_code'] . ' - ' . $permit['property_address']); ?></p>
                    <p class="mt-4"><strong>Notas del Solicitante:</strong></p>
                    <p class="text-gray-700 whitespace-pre-wrap"><?php echo htmlspecialchars($permit['notes'] ?: 'N/A'); ?></p>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Datos del Solicitante</h2>
                    <p><strong>Contribuyente:</strong> <?php echo htmlspecialchars($permit['company_name'] ?: $permit['first_name'] . ' ' . $permit['last_name']); ?></p>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($permit['document_number']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($permit['email']); ?></p>
                    <p><strong>Teléfono:</strong> <?php echo htmlspecialchars($permit['phone']); ?></p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Documento Adjunto</h2>
                    <?php if ($permit['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($permit['file_path']); ?>" target="_blank" class="text-blue-600 hover:underline flex items-center">
                            <i class="fas fa-file-pdf mr-2"></i> <?php echo htmlspecialchars($permit['file_name']); ?>
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó ningún documento.</p>
                    <?php endif; ?>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Acciones</h2>
                    <form action="actions/admin_permit_actions.php" method="POST">
                        <input type="hidden" name="permit_id" value="<?php echo $permit['id']; ?>">
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium">Motivo del Rechazo (si aplica)</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>
                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg">Aprobar Permiso</button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg">Rechazar Solicitud</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>