<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminPropertyController.php';

$currentPage = 'property_verifications';
$controller = new AdminPropertyController();
$propertyId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$propertyId || !($property = $controller->getPropertyDetails($propertyId))) {
    setAlert('Inmueble no encontrado.', 'error');
    header('Location: property_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles del Inmueble - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Revisión de Inmueble: <?php echo htmlspecialchars($property['cadastral_code']); ?></h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información del Contribuyente</h2>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($property['document_number']); ?></p>
                    <p><strong>Nombre/Razón Social:</strong> <?php echo htmlspecialchars($property['company_name'] ?: $property['first_name'] . ' ' . $property['last_name']); ?></p>
                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Datos del Inmueble</h2>
                    <p><strong>Cédula Catastral:</strong> <?php echo htmlspecialchars($property['cadastral_code']); ?></p>
                    <p><strong>Dirección:</strong> <?php echo htmlspecialchars($property['address']); ?></p>
                    <p><strong>Tipo:</strong> <?php echo htmlspecialchars($property['property_type']); ?></p>
                    <p><strong>Área:</strong> <?php echo htmlspecialchars($property['area_m2']); ?> m²</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Documento Adjunto</h2>
                    <?php if ($property['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($property['file_path']); ?>" target="_blank" class="text-blue-600 hover:underline flex items-center">
                            <i class="fas fa-file-alt mr-2"></i> <?php echo htmlspecialchars($property['file_name']); ?>
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó documento.</p>
                    <?php endif; ?>
                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Acciones</h2>
                    <form action="actions/admin_property_actions.php" method="POST">
                        <input type="hidden" name="property_id" value="<?php echo $property['id']; ?>">
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium">Motivo del Rechazo (si aplica)</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>
                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg">Aprobar Inmueble</button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg">Rechazar</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>