<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminPropertyController.php';

$currentPage = 'property_verifications';
$controller = new AdminPropertyController();
$pendingProperties = $controller->getPendingProperties();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Verificación de Inmuebles - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Inmuebles Pendientes de Verificación</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha Solicitud</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Cédula Catastral</th>
                            <th class="p-3 text-left">Dirección</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pendingProperties)): ?>
                            <tr><td colspan="5" class="p-4 text-center text-gray-500">No hay inmuebles pendientes por verificar.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pendingProperties as $property): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($property['created_at']); ?></td>
                                    <td class="p-3 text-sm">
                                        <?php echo htmlspecialchars($property['document_number']); ?><br>
                                        <small><?php echo htmlspecialchars($property['company_name'] ?: $property['first_name'] . ' ' . $property['last_name']); ?></small>
                                    </td>
                                    <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($property['cadastral_code']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($property['address']); ?></td>
                                    <td class="p-3 text-center">
                                        <a href="property_details.php?id=<?php echo $property['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">Revisar</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>