<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminReportController.php';

$currentPage = 'citizen_reports';
$controller = new AdminReportController();
$reportId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$reportId || !($report = $controller->getReportDetails($reportId))) {
    setAlert('Reporte no encontrado.', 'error');
    header('Location: citizen_reports.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles del Reporte - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Detalles del Reporte #<?php echo $report['id']; ?></h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información del Reporte</h2>
                    <p><strong>Título:</strong> <?php echo htmlspecialchars($report['title']); ?></p>
                    <p><strong>Categoría:</strong> <?php echo htmlspecialchars($report['category']); ?></p>
                    <p><strong>Ubicación:</strong> <?php echo htmlspecialchars($report['location']); ?></p>
                    <p class="mt-4"><strong>Descripción:</strong></p>
                    <p class="text-gray-700 whitespace-pre-wrap"><?php echo htmlspecialchars($report['description']); ?></p>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Reportado Por</h2>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($report['document_number']); ?></p>
                    <p><strong>Nombre:</strong> <?php echo htmlspecialchars($report['company_name'] ?: $report['first_name'] . ' ' . $report['last_name']); ?></p>
                </div>
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Foto Adjunta</h2>
                    <?php if ($report['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($report['file_path']); ?>" target="_blank">
                            <img src="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($report['file_path']); ?>" alt="Foto del reporte" class="w-full h-auto rounded-lg shadow-sm">
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó ninguna foto.</p>
                    <?php endif; ?>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Gestionar Reporte</h2>
                    <form action="actions/admin_report_actions.php" method="POST">
                        <input type="hidden" name="report_id" value="<?php echo $report['id']; ?>">
                        <div class="mb-4">
                            <label for="new_status" class="block text-sm font-medium">Cambiar Estado</label>
                            <select name="new_status" id="new_status" class="w-full mt-1 form-select">
                                <option value="open" <?php echo ($report['status'] == 'open') ? 'selected' : ''; ?>>Abierto</option>
                                <option value="in_progress" <?php echo ($report['status'] == 'in_progress') ? 'selected' : ''; ?>>En Progreso</option>
                                <option value="resolved" <?php echo ($report['status'] == 'resolved') ? 'selected' : ''; ?>>Resuelto</option>
                                <option value="closed" <?php echo ($report['status'] == 'closed') ? 'selected' : ''; ?>>Cerrado</option>
                            </select>
                        </div>
                        <button type="submit" name="action" value="update_status" class="w-full bg-blue-600 text-white py-2 rounded-lg">
                            <i class="fas fa-save mr-2"></i>Actualizar Estado
                        </button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>