<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/ReportController.php';

$currentPage = 'reports';
$report_type = $_GET['type'] ?? null;

if (!$report_type) {
    header('Location: reports.php');
    exit;
}

$controller = new ReportController();
$reportData = [];
$reportTitle = '';
$reportHeaders = [];
$totalAmount = 0; // Para sumar el total en el reporte de recaudación

// Lógica para cargar los datos según el tipo de reporte
switch ($report_type) {
    case 'defaulters':
        $reportTitle = 'Reporte de Contribuyentes Morosos';
        $reportData = $controller->getDefaultersReport();
        $reportHeaders = ['Nombre / Razón Social', 'Documento', 'Email / Teléfono', 'Deudas Vencidas', 'Monto Total Adeudado (Bs.)'];
        break;
    
    case 'tax_collection':
        $startDate = $_GET['start_date'] ?? date('Y-m-01');
        $endDate = $_GET['end_date'] ?? date('Y-m-t');
        $reportTitle = 'Reporte de Recaudación desde ' . formatDate($startDate) . ' hasta ' . formatDate($endDate);
        $reportData = $controller->getTaxCollectionReport($startDate, $endDate);
        $reportHeaders = ['Fecha de Pago', 'Contribuyente', 'Concepto', 'Referencia', 'Monto Pagado'];
        foreach ($reportData as $row) {
            $totalAmount += $row['amount'];
        }
        break;

    default:
        setAlert('El tipo de reporte solicitado no es válido.', 'error');
        header('Location: reports.php');
        exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title><?php echo htmlspecialchars($reportTitle); ?> - Admin</title>
    <?php include 'partials/head.php'; ?>
    <style>@media print{body *{visibility:hidden;}.printable-area,.printable-area *{visibility:visible;}.printable-area{position:absolute;left:0;top:0;width:100%;}.no-print{display:none;}}</style>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4 flex justify-between items-center no-print">
            <h1 class="text-xl font-bold"><?php echo htmlspecialchars($reportTitle); ?></h1>
            <div>
                <a href="reports.php" class="text-sm text-blue-600 hover:underline">&larr; Volver a Reportes</a>
                <button onclick="window.print()" class="bg-blue-500 text-white px-4 py-2 rounded-lg ml-4 text-sm"><i class="fas fa-print mr-2"></i>Imprimir</button>
            </div>
        </header>

        <main class="p-6 printable-area">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto p-4">
                <div class="mb-4 text-center print-only"> <h1 class="text-2xl font-bold"><?php echo getSystemConfig('site_name') ?: 'Sistema Municipal'; ?></h1>
                    <h2 class="text-lg"><?php echo htmlspecialchars($reportTitle); ?></h2>
                    <hr class="my-2">
                </div>
                <table class="w-full">
                    <thead class="bg-gray-100 border-b-2 border-gray-300">
                        <tr><?php foreach ($reportHeaders as $header): ?><th class="p-3 text-left text-sm font-semibold text-gray-700"><?php echo $header; ?></th><?php endforeach; ?></tr>
                    </thead>
                    <tbody>
                        <?php if (empty($reportData)): ?>
                            <tr><td colspan="<?php echo count($reportHeaders); ?>" class="p-4 text-center text-gray-500">No se encontraron datos para este reporte.</td></tr>
                        <?php else: ?>
                            <?php foreach ($reportData as $row): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <?php if ($report_type === 'defaulters'): ?>
                                        <td class="p-3 text-sm"><?php echo htmlspecialchars($row['company_name'] ?: $row['first_name'] . ' ' . $row['last_name']); ?></td>
                                        <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($row['document_number']); ?></td>
                                        <td class="p-3 text-sm"><?php echo htmlspecialchars($row['email']); ?><br><small><?php echo htmlspecialchars($row['phone'] ?: 'N/A'); ?></small></td>
                                        <td class="p-3 text-sm text-center"><?php echo $row['overdue_taxes_count']; ?></td>
                                        <td class="p-3 text-sm text-right font-mono font-bold"><?php echo number_format($row['total_debt'], 2); ?></td>
                                    <?php elseif ($report_type === 'tax_collection'): ?>
                                        <td class="p-3 text-sm"><?php echo formatDateTime($row['verified_at']); ?></td>
                                        <td class="p-3 text-sm"><?php echo htmlspecialchars($row['company_name'] ?: $row['first_name'] . ' ' . $row['last_name']); ?> (<?php echo htmlspecialchars($row['document_number']); ?>)</td>
                                        <td class="p-3 text-sm"><?php echo htmlspecialchars($row['tax_concept']); ?></td>
                                        <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($row['reference_number']); ?></td>
                                        <td class="p-3 text-sm text-right font-mono font-bold"><?php echo htmlspecialchars($row['currency_symbol']) . ' ' . number_format($row['amount'], 2); ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                    <?php if ($report_type === 'tax_collection' && $totalAmount > 0): ?>
                    <tfoot class="bg-gray-100 font-bold">
                        <tr>
                            <td colspan="4" class="p-3 text-right">Total Recaudado:</td>
                            <td class="p-3 text-right font-mono"><?php echo 'Bs. ' . number_format($totalAmount, 2); ?></td>
                        </tr>
                    </tfoot>
                    <?php endif; ?>
                </table>
            </div>
        </main>
    </div>
</body>
</html>