<?php
require_once '../config/config.php';
requireAdmin();

$currentPage = 'reports';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Generador de Reportes - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Generador de Reportes</h1></header>
        <main class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                
                <div class="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition">
                    <div class="flex items-center">
                        <div class="bg-red-100 text-red-600 p-3 rounded-full mr-4"><i class="fas fa-user-clock fa-lg"></i></div>
                        <div>
                            <h3 class="font-semibold text-lg">Contribuyentes Morosos</h3>
                            <p class="text-sm text-gray-600">Lista de usuarios con deudas vencidas.</p>
                        </div>
                    </div>
                    <div class="mt-4 text-right">
                        <a href="report_view.php?type=defaulters" class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600 text-sm font-semibold">Generar Reporte</a>
                    </div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition">
                    <form action="report_view.php" method="GET">
                        <input type="hidden" name="type" value="tax_collection">
                        <div class="flex items-center mb-4">
                            <div class="bg-green-100 text-green-600 p-3 rounded-full mr-4"><i class="fas fa-cash-register fa-lg"></i></div>
                            <div>
                                <h3 class="font-semibold text-lg">Recaudación de Impuestos</h3>
                                <p class="text-sm text-gray-600">Pagos verificados en un período.</p>
                            </div>
                        </div>
                        <div class="space-y-3">
                            <div>
                                <label for="start_date" class="text-xs font-medium">Desde:</label>
                                <input type="date" name="start_date" required class="w-full text-sm form-input">
                            </div>
                            <div>
                                <label for="end_date" class="text-xs font-medium">Hasta:</label>
                                <input type="date" name="end_date" required class="w-full text-sm form-input">
                            </div>
                        </div>
                        <div class="mt-4 text-right">
                            <button type="submit" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 text-sm font-semibold">Generar Reporte</button>
                        </div>
                    </form>
                </div>

            </div>
        </main>
    </div>
</body>
</html>