<?php
require_once '../config/config.php';
requireAdmin();
// Proteger esta página solo para Super Admin
require_once 'controllers/AdminRoleController.php';

$currentPage = 'roles';
$controller = new AdminRoleController();
$roleId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$roleId || !($role = $controller->getRoleById($roleId))) {
    setAlert('Rol no encontrado.', 'error');
    header('Location: roles.php');
    exit;
}

$allPermissions = $controller->getAllPermissions();
$rolePermissions = $controller->getRolePermissions($roleId);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Editar Permisos del Rol: <?php echo htmlspecialchars($role['name']); ?> - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Gestionar Permisos para: <?php echo htmlspecialchars($role['name']); ?></h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md p-8 max-w-4xl mx-auto">
                <form action="actions/admin_role_actions.php" method="POST">
                    <input type="hidden" name="action" value="update_permissions">
                    <input type="hidden" name="role_id" value="<?php echo $role['id']; ?>">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <?php foreach($allPermissions as $permission): ?>
                        <label class="flex items-center p-3 border rounded-lg hover:bg-gray-50">
                            <input type="checkbox" name="permissions[]" value="<?php echo $permission['id']; ?>" class="rounded"
                                <?php echo in_array($permission['id'], $rolePermissions) ? 'checked' : ''; ?>>
                            <span class="ml-3 text-sm font-medium"><?php echo htmlspecialchars($permission['name']); ?></span>
                        </label>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="mt-8 pt-6 border-t flex justify-end">
                        <a href="roles.php" class="btn-secondary mr-3">Cancelar</a>
                        <button type="submit" class="btn-primary"><i class="fas fa-save mr-2"></i>Guardar Cambios</button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>