<?php
require_once '../config/config.php';
requireAdmin();
// Proteger esta página solo para Super Admin en el futuro
require_once 'controllers/AdminRoleController.php';

$currentPage = 'roles';
$controller = new AdminRoleController();
$roles = $controller->getAllRoles();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Gestión de Roles - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Gestión de Roles y Permisos</h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Nombre del Rol</th>
                            <th class="p-3 text-left">Descripción</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($roles as $role): ?>
                        <tr class="border-b hover:bg-gray-50">
                            <td class="p-3 font-semibold"><?php echo htmlspecialchars($role['name']); ?></td>
                            <td class="p-3 text-sm"><?php echo htmlspecialchars($role['description']); ?></td>
                            <td class="p-3 text-center">
                                <a href="role_form.php?id=<?php echo $role['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">
                                    <i class="fas fa-edit mr-1"></i>Gestionar Permisos
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>