<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/SettingsController.php';

$currentPage = 'settings';
$controller = new SettingsController();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $controller->saveSettings($_POST, $_FILES);
    setAlert('Configuración guardada exitosamente.', 'success');
    header('Location: settings.php');
    exit;
}

$settings = $controller->getAllSettings();
$taxConcepts = $db->query("SELECT id, name FROM tax_concepts ORDER BY name")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Configuración del Sistema - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Configuración General del Sistema</h1>
        </header>
        <main class="p-6">
            <form action="settings.php" method="POST" enctype="multipart/form-data" class="max-w-4xl mx-auto bg-white p-8 rounded-lg shadow-md space-y-8">
                
                <div class="border-b pb-6">
                    <h2 class="text-lg font-semibold text-gray-800 mb-4">Identidad del Sitio</h2>
                    </div>

                <div class="border-b pb-6">
                    <h2 class="text-lg font-semibold text-gray-800 mb-4">Asignación de Conceptos Tributarios</h2>
                    <div class="space-y-4">
                        <div>
                            <label for="vehicle_tax_concept_id" class="block text-sm font-medium text-gray-700">Concepto para Impuesto Vehicular</label>
                            <select name="vehicle_tax_concept_id" id="vehicle_tax_concept_id" class="mt-1 block w-full form-select">
                                <option value="">-- No asignado --</option>
                                <?php foreach ($taxConcepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>" <?php echo (isset($settings['vehicle_tax_concept_id']) && $settings['vehicle_tax_concept_id'] == $concept['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($concept['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label for="property_tax_concept_id" class="block text-sm font-medium text-gray-700">Concepto para Impuesto de Inmuebles</label>
                            <select name="property_tax_concept_id" id="property_tax_concept_id" class="mt-1 block w-full form-select">
                                <option value="">-- No asignado --</option>
                                <?php foreach ($taxConcepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>" <?php echo (isset($settings['property_tax_concept_id']) && $settings['property_tax_concept_id'] == $concept['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($concept['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div>
                            <label for="advertisement_tax_concept_id" class="block text-sm font-medium text-gray-700">Concepto para Publicidad y Propaganda</label>
                            <select name="advertisement_tax_concept_id" id="advertisement_tax_concept_id" class="mt-1 block w-full form-select">
                                <option value="">-- No asignado --</option>
                                <?php foreach ($taxConcepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>" <?php echo (isset($settings['advertisement_tax_concept_id']) && $settings['advertisement_tax_concept_id'] == $concept['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($concept['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div>
                            <label for="isae_tax_concept_id" class="block text-sm font-medium text-gray-700">Concepto para Actividades Económicas (ISAE)</label>
                            <select name="isae_tax_concept_id" id="isae_tax_concept_id" class="mt-1 block w-full form-select">
                                <option value="">-- No asignado --</option>
                                <?php foreach ($taxConcepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>" <?php echo (isset($settings['isae_tax_concept_id']) && $settings['isae_tax_concept_id'] == $concept['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($concept['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="border-t pt-4">
                            <label for="fine_tax_concept_id" class="block text-sm font-medium text-red-700">Concepto para Multas Fiscales</label>
                            <select name="fine_tax_concept_id" id="fine_tax_concept_id" class="mt-1 block w-full form-select border-red-300 focus:border-red-500 focus:ring-red-500">
                                <option value="">-- ¡MUY IMPORTANTE ASIGNAR ESTO! --</option>
                                <?php foreach ($taxConcepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>" <?php echo (isset($settings['fine_tax_concept_id']) && $settings['fine_tax_concept_id'] == $concept['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($concept['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">Seleccione el concepto que se usará para registrar las deudas generadas por multas en el módulo de fiscalización.</p>
                        </div>
                        </div>
                </div>

                <div class="flex justify-end pt-2">
                    <button type="submit" class="btn-primary flex items-center"><i class="fas fa-save mr-2"></i>Guardar Configuración</button>
                </div>
            </form>
        </main>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>