<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/PermitController.php';

$user = $auth->getUser();
$controller = new PermitController();
$permitTypes = $controller->getEventPermitTypes();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitar Permiso de Eventos o Economía Informal - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Solicitar Permiso de Eventos o Economía Informal</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-3xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/permit_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="request_event_permit">
                        <div class="space-y-6">
                            <div>
                                <label for="permit_type_id" class="block text-sm font-medium mb-2">Tipo de Permiso</label>
                                <select name="permit_type_id" id="permit_type_id" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="">Seleccione el tipo de permiso...</option>
                                    <?php foreach ($permitTypes as $type): ?>
                                        <option value="<?php echo $type['id']; ?>"><?php echo htmlspecialchars($type['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div>
                                <label for="notes" class="block text-sm font-medium mb-2">Descripción Detallada del Evento o Actividad</label>
                                <textarea name="notes" id="notes" rows="4" class="w-full px-3 py-2 border rounded-lg" placeholder="Describa la actividad, fecha, lugar, y cualquier otro detalle relevante." required></textarea>
                            </div>
                            <div>
                                <label for="document_support" class="block text-sm font-medium mb-2">Documento de Soporte (Cédula, RIF, etc.)</label>
                                <input type="file" name="document_support" id="document_support" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0" required>
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-permisos.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar Solicitud
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>