<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/TaxConceptController.php';

$currentPage = 'tax_concepts';
$controller = new TaxConceptController();
$concept = ['id' => '', 'name' => '', 'description' => '', 'aliquota' => '', 'base_amount' => '', 'calculation_method' => 'percentage'];
$pageTitle = 'Nuevo Concepto Tributario';

if (isset($_GET['id'])) {
    $conceptData = $controller->getById($_GET['id']);
    if($conceptData) {
        $concept = $conceptData;
    }
    $pageTitle = 'Editar Concepto Tributario';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title><?php echo $pageTitle; ?> - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
             <h1 class="text-xl font-bold text-gray-800"><?php echo $pageTitle; ?></h1>
        </header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md p-8 max-w-2xl mx-auto">
                <form action="actions/tax_concept_actions.php" method="POST">
                    <input type="hidden" name="id" value="<?php echo $concept['id']; ?>">
                    
                    <div class="mb-4">
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Nombre del Concepto</label>
                        <input type="text" name="name" id="name" value="<?php echo htmlspecialchars($concept['name']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500" required>
                    </div>

                    <div class="mb-4">
                        <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Descripción</label>
                        <textarea name="description" id="description" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"><?php echo htmlspecialchars($concept['description']); ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="calculation_method" class="block text-sm font-medium text-gray-700 mb-2">Método de Cálculo</label>
                        <select name="calculation_method" id="calculation_method" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                            <option value="percentage" <?php echo ($concept['calculation_method'] == 'percentage') ? 'selected' : ''; ?>>Porcentaje (Alícuota)</option>
                            <option value="fixed" <?php echo ($concept['calculation_method'] == 'fixed') ? 'selected' : ''; ?>>Monto Fijo</option>
                            <option value="mixed" <?php echo ($concept['calculation_method'] == 'mixed') ? 'selected' : ''; ?>>Mixto (Ambos)</option>
                        </select>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="mb-4">
                            <label for="aliquota" class="block text-sm font-medium text-gray-700 mb-2">Alícuota (%)</label>
                            <input type="number" step="0.01" name="aliquota" id="aliquota" value="<?php echo htmlspecialchars($concept['aliquota']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500" placeholder="Ej: 1.5">
                        </div>
                        <div class="mb-4">
                            <label for="base_amount" class="block text-sm font-medium text-gray-700 mb-2">Monto Base / Mínimo (Bs.)</label>
                            <input type="number" step="0.01" name="base_amount" id="base_amount" value="<?php echo htmlspecialchars($concept['base_amount']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500" placeholder="Ej: 500.00">
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-end items-center">
                        <a href="tax_concepts.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300 transition mr-3">Cancelar</a>
                        <button type="submit" name="action" value="save" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition flex items-center">
                            <i class="fas fa-save mr-2"></i>
                            Guardar Concepto
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>