<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/TaxConceptController.php';

$currentPage = 'tax_concepts';
$controller = new TaxConceptController();
$concepts = $controller->getAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Conceptos Tributarios - Admin</title>
    <?php include 'partials/head.php'; // Crearemos este partial para reusar el head ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4 flex justify-between items-center">
            <button onclick="toggleSidebar()" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-bars text-gray-600"></i></button>
            <h1 class="text-xl font-bold text-gray-800">Conceptos Tributarios</h1>
            <a href="tax_concept_form.php" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition"><i class="fas fa-plus mr-2"></i>Nuevo Concepto</a>
        </header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="p-3 text-left">Nombre</th>
                            <th class="p-3 text-left">Método Cálculo</th>
                            <th class="p-3 text-left">Alícuota (%)</th>
                            <th class="p-3 text-left">Monto Base</th>
                            <th class="p-3">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($concepts as $concept): ?>
                        <tr class="border-b hover:bg-gray-50">
                            <td class="p-3"><?php echo htmlspecialchars($concept['name']); ?></td>
                            <td class="p-3"><?php echo ucfirst(htmlspecialchars($concept['calculation_method'])); ?></td>
                            <td class="p-3"><?php echo $concept['aliquota'] ? number_format($concept['aliquota'], 2) . '%' : 'N/A'; ?></td>
                            <td class="p-3"><?php echo $concept['base_amount'] ? 'Bs. ' . number_format($concept['base_amount'], 2) : 'N/A'; ?></td>
                            <td class="p-3 text-center">
                                <a href="tax_concept_form.php?id=<?php echo $concept['id']; ?>" class="text-blue-600 hover:text-blue-800 mr-3"><i class="fas fa-edit"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>