<?php
require_once '../config/config.php';
requireAdmin();
$currentPage = 'taxes';

$db = Database::getInstance();
$concepts = $db->query("SELECT id, name FROM tax_concepts ORDER BY name")->fetchAll();
$users = $db->query("SELECT id, document_number, first_name, last_name, company_name FROM users WHERE role = 'citizen' ORDER BY document_number")->fetchAll();
$currencies = $db->query("SELECT id, code FROM currencies WHERE is_active = 1 ORDER BY code")->fetchAll();

$pageTitle = "Asignar Nuevo Impuesto";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title><?php echo $pageTitle; ?> - Sistema Municipal</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-md border-b p-4"><h1 class="text-xl font-bold"><?php echo $pageTitle; ?></h1></header>
        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md p-8 max-w-4xl mx-auto">
                <form action="actions/tax_actions.php" method="POST">
                    <input type="hidden" name="tax_id" value="">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="user_id" class="block text-sm font-medium text-gray-700 mb-2">Contribuyente</label>
                            <select name="user_id" id="user_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                                <option value="">Seleccione un contribuyente...</option>
                                <?php foreach ($users as $user): ?>
                                    <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['document_number'] . ' - ' . ($user['company_name'] ?: $user['first_name'] . ' ' . $user['last_name'])); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="tax_concept_id" class="block text-sm font-medium text-gray-700 mb-2">Concepto del Impuesto</label>
                            <select name="tax_concept_id" id="tax_concept_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                                <option value="">Seleccione un concepto...</option>
                                <?php foreach ($concepts as $concept): ?>
                                    <option value="<?php echo $concept['id']; ?>"><?php echo htmlspecialchars($concept['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div id="property-container" class="hidden md:col-span-2">
                            <label for="property_id" class="block text-sm font-medium text-gray-700 mb-2">Inmueble Asociado (Opcional)</label>
                            <select name="property_id" id="property_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                                </select>
                        </div>
                        <div>
                            <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Monto a Pagar</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                        </div>
                        <div>
                            <label for="currency_id" class="block text-sm font-medium text-gray-700 mb-2">Moneda</label>
                            <select name="currency_id" id="currency_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                                <?php foreach ($currencies as $currency): ?>
                                    <option value="<?php echo $currency['id']; ?>"><?php echo htmlspecialchars($currency['code']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="due_date" class="block text-sm font-medium text-gray-700 mb-2">Fecha de Vencimiento</label>
                            <input type="date" name="due_date" id="due_date" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                        </div>
                        <div class="md:col-span-2">
                             <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Descripción (Opcional)</label>
                             <textarea name="description" id="description" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg"></textarea>
                        </div>
                    </div>
                    <div class="mt-8 pt-6 border-t flex justify-end">
                        <a href="taxes.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                        <button type="submit" name="action" value="save_tax" class="bg-purple-600 text-white px-4 py-2 rounded-lg flex items-center">
                            <i class="fas fa-plus-circle mr-2"></i>Asignar Impuesto
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <script>
        document.getElementById('user_id').addEventListener('change', function() {
            const userId = this.value;
            const propertyContainer = document.getElementById('property-container');
            const propertySelect = document.getElementById('property_id');

            // Limpiar y ocultar el campo de inmuebles
            propertySelect.innerHTML = '<option value="">-- Opcional --</option>';
            propertyContainer.classList.add('hidden');

            if (userId) {
                // Hacer la llamada a nuestra API
                fetch(`api/get_user_properties.php?user_id=${userId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success && data.properties.length > 0) {
                            // Si se encontraron inmuebles, los añadimos al select y lo mostramos
                            data.properties.forEach(property => {
                                const option = document.createElement('option');
                                option.value = property.id;
                                option.textContent = `${property.cadastral_code} - ${property.address}`;
                                propertySelect.appendChild(option);
                            });
                            propertyContainer.classList.remove('hidden');
                        }
                    })
                    .catch(error => console.error('Error al cargar los inmuebles:', error));
            }
        });
    </script>
</body>
</html>