<?php
require_once '../config/config.php';
requireAdmin();

// 1. Incluimos el nuevo controlador
require_once 'controllers/TaxController.php';

$currentPage = 'taxes';

// 2. Creamos una instancia del controlador y obtenemos los datos
$taxController = new TaxController();
$taxes = $taxController->getAllTaxes(); 
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Impuestos - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-gray-100">

    <?php include 'partials/sidebar.php'; ?>

    <div class="main-content">
        <header class="bg-white shadow-sm border-b">
             <div class="flex items-center justify-between p-4">
                <button onclick="toggleSidebar()" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-bars text-gray-600"></i></button>
                <div class="flex items-center space-x-4">
                    <span class="text-sm font-medium">Admin</span>
                    <i class="fas fa-user-circle text-2xl text-gray-500"></i>
                </div>
            </div>
        </header>

        <main class="p-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Gestión de Impuestos</h1>
                    <p class="text-gray-600">Crear, asignar y administrar obligaciones tributarias</p>
                </div>
                <a href="tax_form.php" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition">
                    <i class="fas fa-plus mr-2"></i>Asignar Nuevo Impuesto
                </a>
            </div>

            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($taxes)): ?>
                            <tr>
                                <td colspan="7" class="p-4 text-center text-gray-500">No hay impuestos registrados.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($taxes as $tax): ?>
                            <tr class="border-b hover:bg-gray-50">
                                <td class="p-3 text-sm text-gray-700"><?php echo $tax['id']; ?></td>
                                <td class="p-3 text-sm text-gray-700"><?php echo htmlspecialchars($tax['user_document']); ?></td>
                                <td class="p-3 text-sm text-gray-700"><?php echo htmlspecialchars($tax['tax_type']); ?></td>
                                <td class="p-3 text-sm text-gray-700 font-mono"><?php echo number_format($tax['amount'], 2) . ' ' . htmlspecialchars($tax['currency_code']); ?></td>
                                <td class="p-3 text-sm">
                                    <span class="px-2 py-1 rounded-full text-xs font-semibold <?php 
                                        switch($tax['status']) {
                                            case 'paid': echo 'bg-green-100 text-green-700'; break;
                                            case 'pending': echo 'bg-yellow-100 text-yellow-700'; break;
                                            case 'overdue': echo 'bg-red-100 text-red-700'; break;
                                            default: echo 'bg-gray-100 text-gray-700';
                                        }
                                    ?>"><?php echo ucfirst(htmlspecialchars($tax['status'])); ?></span>
                                </td>
                                <td class="p-3 text-sm text-gray-700"><?php echo formatDate($tax['due_date']); ?></td>
                                <td class="p-3 text-sm">
                                    <a href="tax_form.php?id=<?php echo $tax['id']; ?>" class="text-blue-600 hover:text-blue-800 mr-3"><i class="fas fa-edit"></i></a>
                                    <a href="#" onclick="deleteTax(<?php echo $tax['id']; ?>)" class="text-red-600 hover:text-red-800"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    
    <script src="assets/js/main.js"></script>
    <script>
    function deleteTax(taxId) {
        if (confirm('¿Está seguro de que desea eliminar este impuesto? Esta acción no se puede deshacer.')) {
            // La lógica de eliminación se implementará con un action file o AJAX.
            // window.location.href = 'tax_actions.php?action=delete&id=' + taxId;
            alert('Funcionalidad de eliminar aún no implementada.');
        }
    }
    </script>
</body>
</html>