<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminUserController.php';

$currentPage = 'users';
$controller = new AdminUserController();
$userId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$userId || !($user = $controller->getUserDetails($userId))) {
    setAlert('Contribuyente no encontrado.', 'error');
    header('Location: users.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles del Contribuyente - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4"><h1 class="text-xl font-bold">Detalles del Contribuyente</h1></header>
        <main class="p-6">
            <div class="max-w-4xl mx-auto bg-white p-8 rounded-lg shadow-md">
                <div class="flex justify-between items-start">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($user['company_name'] ?: $user['first_name'] . ' ' . $user['last_name']); ?></h2>
                        <p class="text-sm text-gray-600 font-mono"><?php echo htmlspecialchars($user['document_number']); ?></p>
                    </div>
                    <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo $user['is_active'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                        <?php echo $user['is_active'] ? 'Activo' : 'Inactivo'; ?>
                    </span>
                </div>

                <div class="border-t mt-4 pt-4">
                    <h3 class="font-semibold mb-2">Información de Contacto</h3>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($user['email']); ?></p>
                    <p><strong>Teléfono:</strong> <?php echo htmlspecialchars($user['phone'] ?: 'No registrado'); ?></p>
                    <p><strong>Dirección:</strong> <?php echo htmlspecialchars($user['address'] ?: 'No registrada'); ?></p>
                </div>

                <div class="border-t mt-4 pt-4">
                    <h3 class="font-semibold mb-2">Acciones Administrativas</h3>
                    <div class="flex items-center space-x-4">
                        <?php if ($user['is_active']): ?>
                            <a href="actions/admin_user_actions.php?action=deactivate&id=<?php echo $user['id']; ?>" class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600">
                                <i class="fas fa-times-circle mr-2"></i>Desactivar Cuenta
                            </a>
                        <?php else: ?>
                             <a href="actions/admin_user_actions.php?action=activate&id=<?php echo $user['id']; ?>" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600">
                                <i class="fas fa-check-circle mr-2"></i>Activar Cuenta
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>