<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminUserController.php';

$currentPage = 'users';
$controller = new AdminUserController();
$users = $controller->getAllCitizens();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Gestión de Contribuyentes - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>

    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Gestión de Contribuyentes</h1>
        </header>

        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Nombre / Razón Social</th>
                            <th class="p-3 text-left">Documento</th>
                            <th class="p-3 text-left">Email</th>
                            <th class="p-3 text-center">Tipo</th>
                            <th class="p-3 text-center">Estado</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($users)): ?>
                            <tr><td colspan="6" class="p-4 text-center text-gray-500">No hay contribuyentes registrados.</td></tr>
                        <?php else: ?>
                            <?php foreach ($users as $user): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm font-semibold"><?php echo htmlspecialchars($user['company_name'] ?: $user['first_name'] . ' ' . $user['last_name']); ?></td>
                                    <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($user['document_number']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td class="p-3 text-center text-sm"><?php echo ucfirst($user['user_type']); ?></td>
                                    <td class="p-3 text-center">
                                        <span class="px-2 py-1 text-xs rounded-full <?php echo $user['is_active'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                            <?php echo $user['is_active'] ? 'Activo' : 'Inactivo'; ?>
                                        </span>
                                    </td>
                                    <td class="p-3 text-center">
                                        <a href="user_details.php?id=<?php echo $user['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">
                                            Ver
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>